# Fintech Backend API

A FastAPI-based backend application for handling payment transactions (payin and payout) with multiple payment providers.

## Features

- User authentication and authorization (JWT)
- Admin panel APIs
- Wallet management with transaction history
- Payin and Payout transaction processing
- Multiple payment provider support (Rupeeflow, Unitpay)
- Webhook handling for payment callbacks
- KYC document management
- API key management
- Delayed payin wallet credits with Kafka and DB scheduler
- Transaction settlement tracking

## Prerequisites

- Docker and Docker Compose
- Python 3.11+ (for local development)
- PostgreSQL 15+
- Kafka (for payin credit processing, optional)

## Quick Start

### 1. Clone the repository

```bash
git clone git@github.com:mkansodiya/payin-pyt-api.git
cd payin-pyt-api
```

### 2. Set up environment variables

```bash
cp .env.example .env
# Edit .env with your actual credentials
```

### 3. Start services with Docker Compose

```bash
docker compose up -d
```

This will start:
- PostgreSQL database (port 5434)
- FastAPI application (port 8002)
- Payin credit scheduler service

### 4. Run database migrations

```bash
docker compose exec api alembic upgrade head
```

### 5. Create an admin user

```bash
docker compose exec api python scripts/create_admin.py
```

## Environment Variables

See `.env.example` for all available environment variables. Key variables:

- `DATABASE_URL`: PostgreSQL connection string
- `SECRET_KEY`: JWT secret key (min 32 characters)
- `RUPEEFLOW_API_KEY` / `RUPEEFLOW_SECRET_KEY`: Rupeeflow API credentials
- `UNITPAY_TOKEN`: Unitpay API token
- `KAFKA_BOOTSTRAP_SERVERS`: Kafka server address (if using Kafka)

## API Documentation

Once the application is running, access the interactive API documentation at:
- Swagger UI: `http://localhost:8002/docs`
- ReDoc: `http://localhost:8002/redoc`

## Project Structure

```
.
├── app/
│   ├── api/              # API routes (admin, user, service, webhook)
│   ├── core/             # Core configuration and dependencies
│   ├── models/           # SQLAlchemy models
│   ├── repositories/     # Data access layer
│   ├── schemas/          # Pydantic schemas
│   ├── services/         # Business logic
│   │   └── providers/    # Payment provider implementations
│   └── main.py           # Application entry point
├── alembic/              # Database migrations
├── migrations/           # SQL migrations
├── scripts/              # Utility scripts
├── docker-compose.yml    # Docker Compose configuration
├── Dockerfile            # Docker image definition
├── requirements.txt      # Python dependencies
└── .env.example          # Environment variables template
```

## Development

### Local Development Setup

1. Create a virtual environment:
```bash
python3 -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate
```

2. Install dependencies:
```bash
pip install -r requirements.txt
```

3. Set up environment variables (copy from `.env.example`)

4. Run migrations:
```bash
alembic upgrade head
```

5. Start the development server:
```bash
uvicorn app.main:app --reload
```

## Database Migrations

Create a new migration:
```bash
alembic revision --autogenerate -m "description"
```

Apply migrations:
```bash
alembic upgrade head
```

Rollback:
```bash
alembic downgrade -1
```

## Services

### Main API Service
- Port: 8002 (mapped from container port 8000)
- Handles all API requests

### Payin Credit Scheduler
- Processes delayed payin wallet credits
- Runs as a separate service in Docker Compose
- Can also use Kafka consumer for processing

### Database
- PostgreSQL 15
- Port: 5434 (mapped from container port 5432)
- Data persisted in Docker volume

## Testing

Run tests (if available):
```bash
pytest
```

## Deployment

1. Ensure all environment variables are set in production
2. Update `CORS_ORIGINS` with production frontend URLs
3. Set `ENVIRONMENT=production` and `DEBUG=false`
4. Use a strong `SECRET_KEY` (min 32 characters)
5. Configure proper database credentials
6. Set up reverse proxy (nginx) for production
7. Configure SSL/TLS certificates

## License

[Add your license here]

## Support

[Add support contact information]
