"""update kyc_docs table for front/back files and document_number

Revision ID: 1b13f69eb37e
Revises: f63e03e06025
Create Date: 2025-01-21 16:30:00.000000

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '1b13f69eb37e'
down_revision: Union[str, None] = 'f63e03e06025'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Add new columns
    op.add_column('kyc_docs', sa.Column('document_number', sa.String(length=255), nullable=True))
    op.add_column('kyc_docs', sa.Column('front_file_path', sa.String(length=500), nullable=True))
    op.add_column('kyc_docs', sa.Column('front_file_name', sa.String(length=255), nullable=True))
    op.add_column('kyc_docs', sa.Column('back_file_path', sa.String(length=500), nullable=True))
    op.add_column('kyc_docs', sa.Column('back_file_name', sa.String(length=255), nullable=True))
    
    # Migrate existing data: copy file_path to front_file_path and file_name to front_file_name
    op.execute("""
        UPDATE kyc_docs 
        SET front_file_path = file_path,
            front_file_name = file_name,
            document_number = COALESCE(document_number, 'MIGRATED_' || id::text)
        WHERE front_file_path IS NULL
    """)
    
    # Make new required fields NOT NULL after migration
    op.alter_column('kyc_docs', 'document_number', nullable=False)
    op.alter_column('kyc_docs', 'front_file_path', nullable=False)
    op.alter_column('kyc_docs', 'front_file_name', nullable=False)
    
    # Make kyc_id NOT NULL (it should be required)
    op.execute("""
        UPDATE kyc_docs 
        SET kyc_id = (SELECT id FROM kycs WHERE kycs.user_id = kyc_docs.user_id LIMIT 1)
        WHERE kyc_id IS NULL
    """)
    op.alter_column('kyc_docs', 'kyc_id', nullable=False)
    
    # Drop old columns
    op.drop_column('kyc_docs', 'file_path')
    op.drop_column('kyc_docs', 'file_name')


def downgrade() -> None:
    # Add back old columns
    op.add_column('kyc_docs', sa.Column('file_path', sa.String(length=500), nullable=True))
    op.add_column('kyc_docs', sa.Column('file_name', sa.String(length=255), nullable=True))
    
    # Migrate data back
    op.execute("""
        UPDATE kyc_docs 
        SET file_path = front_file_path,
            file_name = front_file_name
        WHERE file_path IS NULL
    """)
    
    # Make old columns NOT NULL
    op.alter_column('kyc_docs', 'file_path', nullable=False)
    op.alter_column('kyc_docs', 'file_name', nullable=False)
    
    # Make kyc_id nullable again
    op.alter_column('kyc_docs', 'kyc_id', nullable=True)
    
    # Drop new columns
    op.drop_column('kyc_docs', 'back_file_name')
    op.drop_column('kyc_docs', 'back_file_path')
    op.drop_column('kyc_docs', 'front_file_name')
    op.drop_column('kyc_docs', 'front_file_path')
    op.drop_column('kyc_docs', 'document_number')

