"""add_gst_to_charges

Revision ID: add_gst_to_charges
Revises: remove_api_secret_encrypted
Create Date: 2025-01-05 14:00:00.000000

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'add_gst_to_charges'
down_revision = 'remove_api_secret_encrypted_and_update_api_secret'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Add gst column to charges table
    # GST is nullable - if null, default to 18%, if 0, no GST
    op.add_column('charges', sa.Column('gst', sa.Numeric(precision=5, scale=2), nullable=True))


def downgrade() -> None:
    op.drop_column('charges', 'gst')

