"""add_settled_to_payin_transactions

Revision ID: add_settled_to_payin
Revises: add_gst_to_charges
Create Date: 2025-01-05 15:00:00.000000

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'add_settled_to_payin'
down_revision = 'add_gst_to_charges'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Add settled column to payin_transactions table
    # settled = false means wallet not yet credited, true means wallet credited
    op.add_column('payin_transactions', sa.Column('settled', sa.Boolean(), nullable=False, server_default='false', index=True))


def downgrade() -> None:
    op.drop_column('payin_transactions', 'settled')

