"""create_wallets_and_transactions

Revision ID: create_wallets_and_transactions
Revises: create_api_keys_table
Create Date: 2025-12-22 02:00:00.000000

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'create_wallets_and_transactions'
down_revision = 'create_api_keys_table'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Create wallets table
    op.create_table(
        'wallets',
        sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('user_id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('main', sa.Numeric(precision=15, scale=2), nullable=False, server_default='0.00'),
        sa.Column('reserve', sa.Numeric(precision=15, scale=2), nullable=False, server_default='0.00'),
        sa.Column('status', sa.String(length=50), nullable=False, server_default='active'),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('user_id'),
    )
    op.create_index(op.f('ix_wallets_id'), 'wallets', ['id'], unique=False)
    op.create_index(op.f('ix_wallets_user_id'), 'wallets', ['user_id'], unique=False)
    op.create_index(op.f('ix_wallets_status'), 'wallets', ['status'], unique=False)

    # Create wallet_transactions table
    op.create_table(
        'wallet_transactions',
        sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('user_id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('wallet_id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('txn_type', sa.String(length=100), nullable=False),
        sa.Column('type', sa.String(length=20), nullable=False),
        sa.Column('amount', sa.Numeric(precision=15, scale=2), nullable=False),
        sa.Column('opening', sa.Numeric(precision=15, scale=2), nullable=False),
        sa.Column('closing', sa.Numeric(precision=15, scale=2), nullable=False),
        sa.Column('txnid', sa.String(length=100), nullable=False),
        sa.Column('refunded', sa.Boolean(), nullable=False, server_default='false'),
        sa.Column('is_refund', sa.Boolean(), nullable=False, server_default='false'),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
        sa.ForeignKeyConstraint(['wallet_id'], ['wallets.id'], ),
        sa.PrimaryKeyConstraint('id'),
    )
    op.create_index(op.f('ix_wallet_transactions_id'), 'wallet_transactions', ['id'], unique=False)
    op.create_index(op.f('ix_wallet_transactions_user_id'), 'wallet_transactions', ['user_id'], unique=False)
    op.create_index(op.f('ix_wallet_transactions_wallet_id'), 'wallet_transactions', ['wallet_id'], unique=False)
    op.create_index(op.f('ix_wallet_transactions_txn_type'), 'wallet_transactions', ['txn_type'], unique=False)
    op.create_index(op.f('ix_wallet_transactions_type'), 'wallet_transactions', ['type'], unique=False)
    op.create_index(op.f('ix_wallet_transactions_txnid'), 'wallet_transactions', ['txnid'], unique=False)
    op.create_index(op.f('ix_wallet_transactions_refunded'), 'wallet_transactions', ['refunded'], unique=False)
    op.create_index(op.f('ix_wallet_transactions_is_refund'), 'wallet_transactions', ['is_refund'], unique=False)


def downgrade() -> None:
    op.drop_index(op.f('ix_wallet_transactions_is_refund'), table_name='wallet_transactions')
    op.drop_index(op.f('ix_wallet_transactions_refunded'), table_name='wallet_transactions')
    op.drop_index(op.f('ix_wallet_transactions_txnid'), table_name='wallet_transactions')
    op.drop_index(op.f('ix_wallet_transactions_type'), table_name='wallet_transactions')
    op.drop_index(op.f('ix_wallet_transactions_txn_type'), table_name='wallet_transactions')
    op.drop_index(op.f('ix_wallet_transactions_wallet_id'), table_name='wallet_transactions')
    op.drop_index(op.f('ix_wallet_transactions_user_id'), table_name='wallet_transactions')
    op.drop_index(op.f('ix_wallet_transactions_id'), table_name='wallet_transactions')
    op.drop_table('wallet_transactions')
    
    op.drop_index(op.f('ix_wallets_status'), table_name='wallets')
    op.drop_index(op.f('ix_wallets_user_id'), table_name='wallets')
    op.drop_index(op.f('ix_wallets_id'), table_name='wallets')
    op.drop_table('wallets')

