"""add_refunded_columns_to_wallet_transactions

Revision ID: add_refunded_columns
Revises: create_wallets_and_transactions
Create Date: 2025-12-22 03:07:00.000000

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = 'add_refunded_columns'
down_revision = 'create_wallets_and_transactions'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Add refunded and is_refund columns if they don't exist
    op.execute("""
        DO $$ 
        BEGIN
            IF NOT EXISTS (
                SELECT 1 FROM information_schema.columns 
                WHERE table_name = 'wallet_transactions' AND column_name = 'refunded'
            ) THEN
                ALTER TABLE wallet_transactions ADD COLUMN refunded BOOLEAN NOT NULL DEFAULT false;
                CREATE INDEX ix_wallet_transactions_refunded ON wallet_transactions(refunded);
            END IF;
        END $$;
    """)
    
    op.execute("""
        DO $$ 
        BEGIN
            IF NOT EXISTS (
                SELECT 1 FROM information_schema.columns 
                WHERE table_name = 'wallet_transactions' AND column_name = 'is_refund'
            ) THEN
                ALTER TABLE wallet_transactions ADD COLUMN is_refund BOOLEAN NOT NULL DEFAULT false;
                CREATE INDEX ix_wallet_transactions_is_refund ON wallet_transactions(is_refund);
            END IF;
        END $$;
    """)
    
    # Remove unique constraint from txnid if it exists
    op.execute("""
        DO $$ 
        BEGIN
            IF EXISTS (
                SELECT 1 FROM pg_constraint 
                WHERE conname = 'wallet_transactions_txnid_key'
            ) THEN
                ALTER TABLE wallet_transactions DROP CONSTRAINT wallet_transactions_txnid_key;
            END IF;
        END $$;
    """)


def downgrade() -> None:
    op.drop_index('ix_wallet_transactions_is_refund', table_name='wallet_transactions')
    op.drop_index('ix_wallet_transactions_refunded', table_name='wallet_transactions')
    op.drop_column('wallet_transactions', 'is_refund')
    op.drop_column('wallet_transactions', 'refunded')

