"""create_pyttxns_table

Revision ID: c1729c7391f7
Revises: add_refunded_columns
Create Date: 2025-12-22 03:59:18.806357

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'c1729c7391f7'
down_revision = 'add_refunded_columns'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Create pyttxns (payout transactions) table
    op.create_table(
        'pyttxns',
        sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('user_id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('txnid', sa.String(length=100), nullable=False),
        sa.Column('amount', sa.Numeric(precision=15, scale=2), nullable=False),
        sa.Column('charge', sa.Numeric(precision=15, scale=2), nullable=False, server_default='0.00'),
        sa.Column('bene_name', sa.String(length=255), nullable=False),
        sa.Column('bene_ifsc', sa.String(length=20), nullable=False),
        sa.Column('bene_acc_no', sa.String(length=50), nullable=False),
        sa.Column('status', sa.String(length=50), nullable=False, server_default='pending'),
        sa.Column('api_response', postgresql.JSON(astext_type=sa.Text()), nullable=True),
        sa.Column('api_provider', sa.String(length=100), nullable=True),
        sa.Column('provider_reference_id', sa.String(length=255), nullable=True),
        sa.Column('refunded', sa.Boolean(), nullable=False, server_default='false'),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('txnid'),
    )
    op.create_index(op.f('ix_pyttxns_id'), 'pyttxns', ['id'], unique=False)
    op.create_index(op.f('ix_pyttxns_user_id'), 'pyttxns', ['user_id'], unique=False)
    op.create_index(op.f('ix_pyttxns_txnid'), 'pyttxns', ['txnid'], unique=True)
    op.create_index(op.f('ix_pyttxns_status'), 'pyttxns', ['status'], unique=False)
    op.create_index(op.f('ix_pyttxns_provider_reference_id'), 'pyttxns', ['provider_reference_id'], unique=False)
    op.create_index(op.f('ix_pyttxns_refunded'), 'pyttxns', ['refunded'], unique=False)


def downgrade() -> None:
    op.drop_index(op.f('ix_pyttxns_refunded'), table_name='pyttxns')
    op.drop_index(op.f('ix_pyttxns_provider_reference_id'), table_name='pyttxns')
    op.drop_index(op.f('ix_pyttxns_status'), table_name='pyttxns')
    op.drop_index(op.f('ix_pyttxns_txnid'), table_name='pyttxns')
    op.drop_index(op.f('ix_pyttxns_user_id'), table_name='pyttxns')
    op.drop_index(op.f('ix_pyttxns_id'), table_name='pyttxns')
    op.drop_table('pyttxns')
