"""add_user_reference_id_to_pyttxns

Revision ID: 69378436a925
Revises: c1729c7391f7
Create Date: 2025-12-22 04:06:00.000000

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '69378436a925'
down_revision = 'c1729c7391f7'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Add user_reference_id column to pyttxns table
    op.add_column('pyttxns', sa.Column('user_reference_id', sa.String(length=255), nullable=True))
    op.create_index(op.f('ix_pyttxns_user_reference_id'), 'pyttxns', ['user_reference_id'], unique=False)


def downgrade() -> None:
    op.drop_index(op.f('ix_pyttxns_user_reference_id'), table_name='pyttxns')
    op.drop_column('pyttxns', 'user_reference_id')
