"""add_unique_constraint_to_user_reference_id

Revision ID: 979533ec24bb
Revises: 69378436a925
Create Date: 2025-12-22 04:22:10.000000

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '979533ec24bb'
down_revision = '69378436a925'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Drop existing index if it exists
    op.drop_index('ix_pyttxns_user_reference_id', table_name='pyttxns', if_exists=True)
    
    # Add unique constraint on user_reference_id
    op.create_unique_constraint('uq_pyttxns_user_reference_id', 'pyttxns', ['user_reference_id'])
    
    # Recreate index (unique constraint creates an index, but we'll create a non-unique index for faster lookups)
    # Actually, the unique constraint already creates an index, so we don't need a separate one


def downgrade() -> None:
    # Drop unique constraint
    op.drop_constraint('uq_pyttxns_user_reference_id', 'pyttxns', type_='unique')
    
    # Recreate regular index
    op.create_index('ix_pyttxns_user_reference_id', 'pyttxns', ['user_reference_id'], unique=False)
