"""create_payin_transactions_table

Revision ID: create_payin_txns
Revises: 979533ec24bb
Create Date: 2025-12-22 11:00:00.000000

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'create_payin_txns'
down_revision = '979533ec24bb'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Create payin_transactions table
    op.create_table(
        'payin_transactions',
        sa.Column('id', sa.Integer(), nullable=False, autoincrement=True),
        sa.Column('user_id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('txnid', sa.String(length=100), nullable=False),
        sa.Column('user_reference_id', sa.String(length=255), nullable=True),
        sa.Column('amount', sa.Numeric(precision=15, scale=2), nullable=False),
        sa.Column('charge', sa.Numeric(precision=15, scale=2), nullable=False, server_default='0.00'),
        sa.Column('payee_vpa', sa.String(length=255), nullable=True),
        sa.Column('payee_name', sa.String(length=255), nullable=True),
        sa.Column('status', sa.String(length=50), nullable=False, server_default='pending'),
        sa.Column('api_response', postgresql.JSON(astext_type=sa.Text()), nullable=True),
        sa.Column('qr_text', sa.String(length=500), nullable=True),
        sa.Column('payment_url', sa.String(length=500), nullable=True),
        sa.Column('api_provider', sa.String(length=100), nullable=True),
        sa.Column('provider_reference_id', sa.String(length=255), nullable=True),
        sa.Column('refunded', sa.Boolean(), nullable=False, server_default='false'),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('txnid'),
        sa.UniqueConstraint('user_reference_id'),
    )
    op.create_index(op.f('ix_payin_transactions_id'), 'payin_transactions', ['id'], unique=False)
    op.create_index(op.f('ix_payin_transactions_user_id'), 'payin_transactions', ['user_id'], unique=False)
    op.create_index(op.f('ix_payin_transactions_txnid'), 'payin_transactions', ['txnid'], unique=True)
    op.create_index(op.f('ix_payin_transactions_user_reference_id'), 'payin_transactions', ['user_reference_id'], unique=True)
    op.create_index(op.f('ix_payin_transactions_status'), 'payin_transactions', ['status'], unique=False)
    op.create_index(op.f('ix_payin_transactions_provider_reference_id'), 'payin_transactions', ['provider_reference_id'], unique=False)
    op.create_index(op.f('ix_payin_transactions_refunded'), 'payin_transactions', ['refunded'], unique=False)
    op.create_index(op.f('ix_payin_transactions_created_at'), 'payin_transactions', ['created_at'], unique=False)


def downgrade() -> None:
    op.drop_index(op.f('ix_payin_transactions_created_at'), table_name='payin_transactions')
    op.drop_index(op.f('ix_payin_transactions_refunded'), table_name='payin_transactions')
    op.drop_index(op.f('ix_payin_transactions_provider_reference_id'), table_name='payin_transactions')
    op.drop_index(op.f('ix_payin_transactions_status'), table_name='payin_transactions')
    op.drop_index(op.f('ix_payin_transactions_user_reference_id'), table_name='payin_transactions')
    op.drop_index(op.f('ix_payin_transactions_txnid'), table_name='payin_transactions')
    op.drop_index(op.f('ix_payin_transactions_user_id'), table_name='payin_transactions')
    op.drop_index(op.f('ix_payin_transactions_id'), table_name='payin_transactions')
    op.drop_table('payin_transactions')

