"""create_charges_table

Revision ID: create_charges
Revises: create_payin_txns
Create Date: 2025-12-22 12:00:00.000000

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'create_charges'
down_revision = 'create_payin_txns'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Create charges table
    op.create_table(
        'charges',
        sa.Column('id', sa.Integer(), nullable=False, autoincrement=True),
        sa.Column('user_id', postgresql.UUID(as_uuid=True), nullable=True),
        sa.Column('service_id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('from_amount', sa.Numeric(precision=15, scale=2), nullable=False, server_default='0.00'),
        sa.Column('to_amount', sa.Numeric(precision=15, scale=2), nullable=False, server_default='0.00'),
        sa.Column('type', sa.String(length=50), nullable=False),
        sa.Column('is_percent', sa.Boolean(), nullable=False, server_default='false'),
        sa.Column('amount', sa.Numeric(precision=15, scale=2), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
        sa.ForeignKeyConstraint(['service_id'], ['services.id'], ),
        sa.PrimaryKeyConstraint('id'),
    )
    op.create_index(op.f('ix_charges_id'), 'charges', ['id'], unique=False)
    op.create_index(op.f('ix_charges_user_id'), 'charges', ['user_id'], unique=False)
    op.create_index(op.f('ix_charges_service_id'), 'charges', ['service_id'], unique=False)
    op.create_index(op.f('ix_charges_type'), 'charges', ['type'], unique=False)
    op.create_index(op.f('ix_charges_created_at'), 'charges', ['created_at'], unique=False)


def downgrade() -> None:
    op.drop_index(op.f('ix_charges_created_at'), table_name='charges')
    op.drop_index(op.f('ix_charges_type'), table_name='charges')
    op.drop_index(op.f('ix_charges_service_id'), table_name='charges')
    op.drop_index(op.f('ix_charges_user_id'), table_name='charges')
    op.drop_index(op.f('ix_charges_id'), table_name='charges')
    op.drop_table('charges')

