"""create_webhook_tables

Revision ID: create_webhook_tables
Revises: create_charges
Create Date: 2025-12-22 13:00:00.000000

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'create_webhook_tables'
down_revision = 'create_charges'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Create webhook_urls table
    op.create_table(
        'webhook_urls',
        sa.Column('id', sa.Integer(), nullable=False, autoincrement=True),
        sa.Column('user_id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('url', sa.String(length=500), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('user_id'),
    )
    op.create_index(op.f('ix_webhook_urls_id'), 'webhook_urls', ['id'], unique=False)
    op.create_index(op.f('ix_webhook_urls_user_id'), 'webhook_urls', ['user_id'], unique=True)
    op.create_index(op.f('ix_webhook_urls_created_at'), 'webhook_urls', ['created_at'], unique=False)
    
    # Create webhook_logs table
    op.create_table(
        'webhook_logs',
        sa.Column('id', sa.Integer(), nullable=False, autoincrement=True),
        sa.Column('service_id', postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column('txnid', sa.String(length=100), nullable=False),
        sa.Column('payload', postgresql.JSON(astext_type=sa.Text()), nullable=False),
        sa.Column('response', postgresql.JSON(astext_type=sa.Text()), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(['service_id'], ['services.id'], ),
        sa.PrimaryKeyConstraint('id'),
    )
    op.create_index(op.f('ix_webhook_logs_id'), 'webhook_logs', ['id'], unique=False)
    op.create_index(op.f('ix_webhook_logs_service_id'), 'webhook_logs', ['service_id'], unique=False)
    op.create_index(op.f('ix_webhook_logs_txnid'), 'webhook_logs', ['txnid'], unique=False)
    op.create_index(op.f('ix_webhook_logs_created_at'), 'webhook_logs', ['created_at'], unique=False)


def downgrade() -> None:
    op.drop_index(op.f('ix_webhook_logs_created_at'), table_name='webhook_logs')
    op.drop_index(op.f('ix_webhook_logs_txnid'), table_name='webhook_logs')
    op.drop_index(op.f('ix_webhook_logs_service_id'), table_name='webhook_logs')
    op.drop_index(op.f('ix_webhook_logs_id'), table_name='webhook_logs')
    op.drop_table('webhook_logs')
    
    op.drop_index(op.f('ix_webhook_urls_created_at'), table_name='webhook_urls')
    op.drop_index(op.f('ix_webhook_urls_user_id'), table_name='webhook_urls')
    op.drop_index(op.f('ix_webhook_urls_id'), table_name='webhook_urls')
    op.drop_table('webhook_urls')

