"""add_user_id_to_webhook_logs

Revision ID: add_user_id_to_webhook_logs
Revises: create_webhook_tables
Create Date: 2025-12-22 14:00:00.000000

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'add_user_id_to_webhook_logs'
down_revision = 'create_webhook_tables'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Add user_id column to webhook_logs table (nullable initially)
    op.add_column('webhook_logs', sa.Column('user_id', postgresql.UUID(as_uuid=True), nullable=True))
    
    # Create foreign key constraint
    op.create_foreign_key('fk_webhook_logs_user_id', 'webhook_logs', 'users', ['user_id'], ['id'])
    
    # Create index
    op.create_index(op.f('ix_webhook_logs_user_id'), 'webhook_logs', ['user_id'], unique=False)
    
    # Note: If you have existing data in webhook_logs, you'll need to populate user_id first
    # before making it non-nullable. For new installations, this will be empty.
    # Uncomment the line below after populating user_id for existing records:
    # op.alter_column('webhook_logs', 'user_id', nullable=False)


def downgrade() -> None:
    op.drop_index(op.f('ix_webhook_logs_user_id'), table_name='webhook_logs')
    op.drop_constraint('fk_webhook_logs_user_id', 'webhook_logs', type_='foreignkey')
    op.drop_column('webhook_logs', 'user_id')

