"""add_webhook_secret_to_webhook_urls

Revision ID: add_webhook_secret_to_webhook_urls
Revises: add_user_id_to_webhook_logs
Create Date: 2025-12-22 15:00:00.000000

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'add_webhook_secret_to_webhook_urls'
down_revision = 'add_user_id_to_webhook_logs'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Add webhook_secret column to webhook_urls table
    op.add_column('webhook_urls', sa.Column('webhook_secret', sa.String(length=255), nullable=True))
    
    # Note: Existing webhook URLs will have NULL webhook_secret
    # A secret will be auto-generated when the first webhook is sent


def downgrade() -> None:
    op.drop_column('webhook_urls', 'webhook_secret')

