"""add_api_secret_encrypted_to_api_keys

Revision ID: add_api_secret_encrypted_to_api_keys
Revises: add_webhook_secret_to_webhook_urls
Create Date: 2025-12-22 16:00:00.000000

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'add_api_secret_encrypted_to_api_keys'
down_revision = 'add_webhook_secret_to_webhook_urls'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Add api_secret_encrypted column to api_keys table
    op.add_column('api_keys', sa.Column('api_secret_encrypted', sa.String(length=500), nullable=True))
    
    # Note: Existing API keys will have NULL api_secret_encrypted
    # The encrypted secret will be generated when API keys are regenerated


def downgrade() -> None:
    op.drop_column('api_keys', 'api_secret_encrypted')

