"""remove_api_secret_encrypted_and_update_api_secret

Revision ID: remove_api_secret_encrypted_and_update_api_secret
Revises: add_user_id_to_webhook_logs
Create Date: 2025-12-22 17:00:00.000000

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'remove_api_secret_encrypted_and_update_api_secret'
down_revision = 'add_user_id_to_webhook_logs'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Alter api_secret column to allow longer strings (for encrypted data)
    # This allows storing encrypted API secrets (not hashed) for webhook signing
    op.alter_column('api_keys', 'api_secret',
                    existing_type=sa.String(length=255),
                    type_=sa.String(length=500),
                    existing_nullable=False)
    
    # Note: Existing API keys with hashed api_secret will need to be regenerated
    # to work with webhook signing, as the hashed value cannot be decrypted


def downgrade() -> None:
    # Revert api_secret column to original length
    op.alter_column('api_keys', 'api_secret',
                    existing_type=sa.String(length=500),
                    type_=sa.String(length=255),
                    existing_nullable=False)

