"""add status column to kyc_docs

Revision ID: 80aa6dc0d94a
Revises: 
Create Date: 2025-01-21 13:00:00.000000

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '80aa6dc0d94a'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Add status column to kyc_docs table
    op.add_column('kyc_docs', sa.Column('status', sa.String(length=50), nullable=False, server_default='submitted'))
    
    # Create index on status column
    op.create_index(op.f('ix_kyc_docs_status'), 'kyc_docs', ['status'], unique=False)


def downgrade() -> None:
    # Drop index on status column
    op.drop_index(op.f('ix_kyc_docs_status'), table_name='kyc_docs')
    
    # Drop status column from kyc_docs table
    op.drop_column('kyc_docs', 'status')

