"""
Common enums for the application
"""

from enum import Enum


class KYCStatus(str, Enum):
    """KYC status enum"""
    PENDING = "pending"
    UNDER_REVIEW = "under_review"
    APPROVED = "approved"
    REJECTED = "rejected"


class ServiceStatus(str, Enum):
    """Service status enum"""
    ACTIVE = "active"
    INACTIVE = "inactive"
    SUSPENDED = "suspended"


class UserServiceStatus(str, Enum):
    """User Service status enum"""
    PENDING = "pending"
    ACTIVE = "active"
    INACTIVE = "inactive"
    SUSPENDED = "suspended"
    CANCELLED = "cancelled"


class KYCDocStatus(str, Enum):
    """KYC Document status enum"""
    SUBMITTED = "submitted"  # Document uploaded but not yet reviewed
    PENDING = "pending"  # Under review
    APPROVED = "approved"  # Approved
    REJECTED = "rejected"  # Rejected


class WalletStatus(str, Enum):
    """Wallet status enum"""
    ACTIVE = "active"
    INACTIVE = "inactive"
    SUSPENDED = "suspended"


class TransactionType(str, Enum):
    """Transaction type enum"""
    DEBIT = "debit"
    CREDIT = "credit"

