"""
Common Pydantic schemas for responses
"""

from typing import Generic, TypeVar, Optional
from pydantic import BaseModel, ConfigDict
from datetime import datetime
from uuid import UUID

T = TypeVar("T")


class BaseResponse(BaseModel):
    """Base response schema"""
    model_config = ConfigDict(from_attributes=True)


class PaginatedResponse(BaseModel, Generic[T]):
    """Paginated response schema"""
    items: list[T]
    total: int
    page: int
    page_size: int
    total_pages: int

    model_config = ConfigDict(from_attributes=True)


class MessageResponse(BaseModel):
    """Simple message response schema"""
    message: str


class TimestampMixin(BaseModel):
    """Mixin for timestamps in schemas"""
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)


class IDMixin(BaseModel):
    """Mixin for ID in schemas"""
    id: UUID

    model_config = ConfigDict(from_attributes=True)

