"""
Admin model
"""

from sqlalchemy import Column, String, Boolean
from app.common.base_model import BaseModel


class Admin(BaseModel):
    """Admin model"""
    
    __tablename__ = "admins"
    
    email = Column(String(255), unique=True, nullable=False, index=True)
    password_hash = Column(String(255), nullable=False)
    full_name = Column(String(255), nullable=False)
    is_active = Column(Boolean, default=True, nullable=False, index=True)

