"""
API Key model
"""

from sqlalchemy import Column, String, Boolean, ForeignKey, JSON
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from app.common.base_model import BaseModel


class APIKey(BaseModel):
    """API Key model for user API authentication"""
    
    __tablename__ = "api_keys"
    
    user_id = Column(UUID(as_uuid=True), ForeignKey("users.id"), nullable=False, index=True, unique=True)
    api_key = Column(String(255), nullable=False, unique=True, index=True)
    api_secret = Column(String(500), nullable=False)  # Encrypted secret (not hashed, can be decrypted for webhook signing)
    active = Column(Boolean, default=True, nullable=False, index=True)
    ips = Column(JSON, nullable=True, default=list)  # List of whitelisted IPs
    
    # Relationships
    user = relationship("User", back_populates="api_key")

