"""
Charge model
"""

from sqlalchemy import Column, String, Numeric, Boolean, ForeignKey, Integer
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from app.core.database import Base
from app.common.mixins import TimestampMixin


class Charge(Base, TimestampMixin):
    """Charge model for managing service charges"""
    
    __tablename__ = "charges"
    
    id = Column(Integer, primary_key=True, index=True, autoincrement=True)
    user_id = Column(UUID(as_uuid=True), ForeignKey("users.id"), nullable=True, index=True)  # NULL means applies to all users
    service_id = Column(UUID(as_uuid=True), ForeignKey("services.id"), nullable=False, index=True)
    from_amount = Column(Numeric(15, 2), nullable=False, default=0.00)  # 0 means no lower limit
    to_amount = Column(Numeric(15, 2), nullable=False, default=0.00)  # 0 means no upper limit
    type = Column(String(50), nullable=False, index=True)  # "surcharge" or "commission"
    is_percent = Column(Boolean, default=False, nullable=False)  # True for percentage, False for fixed amount
    amount = Column(Numeric(15, 2), nullable=False)  # Charge amount or percentage value
    gst = Column(Numeric(5, 2), nullable=True)  # GST percentage (null = default 18%, 0 = no GST)
    
    # Relationships
    user = relationship("User", back_populates="charges")
    service = relationship("Service", back_populates="charges")

