"""
KYC model
"""

from sqlalchemy import Column, String, ForeignKey, Text
from sqlalchemy.orm import relationship
from sqlalchemy.dialects.postgresql import UUID
from app.common.base_model import BaseModel
from app.common.mixins import StatusMixin


class KYC(BaseModel, StatusMixin):
    """KYC (Know Your Customer) model"""
    
    __tablename__ = "kycs"
    
    user_id = Column(UUID(as_uuid=True), ForeignKey("users.id"), nullable=False, index=True)
    ownership_type = Column(String(50), nullable=False, index=True)  # individual, private_limited, etc.
    document_type = Column(String(100), nullable=True)  # Deprecated - documents are uploaded separately
    document_number = Column(String(255), nullable=True, index=True)  # Deprecated - documents are uploaded separately
    company_name = Column(String(255), nullable=False)  # Company name or individual name
    date_of_birth = Column(String(50), nullable=True)  # For individuals
    
    # Common user documents (PAN and Aadhaar)
    pan_number = Column(String(10), nullable=True, index=True)
    aadhaar_number = Column(String(12), nullable=True, index=True)
    
    address = Column(Text, nullable=True)
    city = Column(String(100), nullable=True)
    state = Column(String(100), nullable=True)
    country = Column(String(100), nullable=True)
    postal_code = Column(String(20), nullable=True)
    notes = Column(Text, nullable=True)
    
    # Relationships
    user = relationship("User", back_populates="kycs")
    kyc_docs = relationship("KYCDoc", back_populates="kyc", cascade="all, delete-orphan")

