"""
KYC Document model
"""

from sqlalchemy import Column, String, ForeignKey, Text
from sqlalchemy.orm import relationship
from sqlalchemy.dialects.postgresql import UUID
from app.common.base_model import BaseModel
from app.common.mixins import StatusMixin


class KYCDoc(BaseModel, StatusMixin):
    """KYC Document model"""
    
    __tablename__ = "kyc_docs"
    
    user_id = Column(UUID(as_uuid=True), ForeignKey("users.id"), nullable=False, index=True)
    kyc_id = Column(UUID(as_uuid=True), ForeignKey("kycs.id"), nullable=False, index=True)
    document_type = Column(String(100), nullable=False, index=True)  # e.g., 'pan_card', 'aadhaar_card', etc.
    document_number = Column(String(255), nullable=False)  # Document number (PAN, Aadhaar, etc.)
    front_file_path = Column(String(500), nullable=False)  # Front side file path
    front_file_name = Column(String(255), nullable=False)
    back_file_path = Column(String(500), nullable=True)  # Back side file path (optional)
    back_file_name = Column(String(255), nullable=True)
    file_size = Column(String(50), nullable=True)
    mime_type = Column(String(100), nullable=True)
    description = Column(Text, nullable=True)
    
    # Relationships
    user = relationship("User", back_populates="kyc_docs")
    kyc = relationship("KYC", back_populates="kyc_docs")

