"""
Payin Transaction model
"""

from sqlalchemy import Column, String, Numeric, Boolean, ForeignKey, JSON, Integer, DateTime
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from datetime import datetime
from app.core.database import Base
from app.common.mixins import TimestampMixin


class PayinTransaction(Base, TimestampMixin):
    """Payin Transaction model with integer primary key"""
    
    __tablename__ = "payin_transactions"
    
    id = Column(Integer, primary_key=True, index=True, autoincrement=True)
    user_id = Column(UUID(as_uuid=True), ForeignKey("users.id"), nullable=False, index=True)
    txnid = Column(String(100), nullable=False, unique=True, index=True)
    user_reference_id = Column(String(255), nullable=True, unique=True, index=True)  # User-provided reference ID (unique)
    amount = Column(Numeric(15, 2), nullable=False)
    charge = Column(Numeric(15, 2), nullable=False, default=0.00)
    payee_vpa = Column(String(255), nullable=True)  # Payee VPA (Virtual Payment Address)
    payee_name = Column(String(255), nullable=True)  # Payee name
    status = Column(String(50), nullable=False, index=True, default="pending")
    api_response = Column(JSON, nullable=True)  # API provider response
    qr_text = Column(String(500), nullable=True)  # QR code text
    payment_url = Column(String(500), nullable=True)  # Payment URL
    api_provider = Column(String(100), nullable=True)  # API provider name
    provider_reference_id = Column(String(255), nullable=True, index=True)  # Provider's reference ID
    refunded = Column(Boolean, default=False, nullable=False, index=True)
    rrn = Column(String(20), nullable=True)  # RRN (Reference Number)
    settled = Column(Boolean, default=False, nullable=False, index=True)  # True when wallet is credited
    scheduled_credit_at = Column(DateTime(timezone=True), nullable=True, index=True)  # When to credit the wallet
    # Relationships
    user = relationship("User", back_populates="payin_transactions")

