"""
Payout Transaction model
"""

from sqlalchemy import Column, String, Numeric, Boolean, ForeignKey, JSON
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from app.common.base_model import BaseModel


class PayoutTransaction(BaseModel):
    """Payout Transaction model"""
    
    __tablename__ = "pyttxns"
    
    user_id = Column(UUID(as_uuid=True), ForeignKey("users.id"), nullable=False, index=True)
    txnid = Column(String(100), nullable=False, unique=True, index=True)
    user_reference_id = Column(String(255), nullable=True, unique=True, index=True)  # User-provided reference ID (unique)
    amount = Column(Numeric(15, 2), nullable=False)
    charge = Column(Numeric(15, 2), nullable=False, default=0.00)
    bene_name = Column(String(255), nullable=False)  # Beneficiary name
    bene_ifsc = Column(String(20), nullable=False)  # Beneficiary IFSC code
    bene_acc_no = Column(String(50), nullable=False)  # Beneficiary account number
    status = Column(String(50), nullable=False, index=True, default="pending")
    api_response = Column(JSON, nullable=True)  # API provider response
    api_provider = Column(String(100), nullable=True)  # API provider name
    provider_reference_id = Column(String(255), nullable=True, index=True)  # Provider's reference ID
    refunded = Column(Boolean, default=False, nullable=False, index=True)
    rrn = Column(String(20), nullable=True)  # RRN (Reference Number)
    # Relationships
    user = relationship("User", back_populates="payout_transactions")

