"""
Service model
"""

from sqlalchemy import Column, String, Text, Numeric
from sqlalchemy.orm import relationship
from app.common.base_model import BaseModel
from app.common.mixins import StatusMixin


class Service(BaseModel, StatusMixin):
    """Service model"""
    
    __tablename__ = "services"
    
    name = Column(String(255), nullable=False, unique=True, index=True)
    description = Column(Text, nullable=True)
    code = Column(String(100), nullable=False, unique=True, index=True)
    price = Column(Numeric(10, 2), nullable=False, default=0.00)
    currency = Column(String(10), nullable=False, default="USD")
    
    # Relationships
    user_services = relationship("UserService", back_populates="service", cascade="all, delete-orphan")
    charges = relationship("Charge", back_populates="service", cascade="all, delete-orphan")
    webhook_logs = relationship("WebhookLog", back_populates="service", cascade="all, delete-orphan")

