"""
User model
"""

from sqlalchemy import Column, String, Boolean
from sqlalchemy.orm import relationship
from app.common.base_model import BaseModel
from app.common.mixins import SoftDeleteMixin


class User(BaseModel, SoftDeleteMixin):
    """User model with soft delete"""
    
    __tablename__ = "users"
    
    email = Column(String(255), unique=True, nullable=False, index=True)
    password_hash = Column(String(255), nullable=False)
    full_name = Column(String(255), nullable=False)
    phone = Column(String(20), nullable=True)
    is_active = Column(Boolean, default=True, nullable=False, index=True)
    
    # Relationships
    kycs = relationship("KYC", back_populates="user", cascade="all, delete-orphan")
    kyc_docs = relationship("KYCDoc", back_populates="user", cascade="all, delete-orphan")
    user_services = relationship("UserService", back_populates="user", cascade="all, delete-orphan")
    api_key = relationship("APIKey", back_populates="user", uselist=False, cascade="all, delete-orphan")
    wallet = relationship("Wallet", back_populates="user", uselist=False, cascade="all, delete-orphan")
    wallet_transactions = relationship("WalletTransaction", back_populates="user", cascade="all, delete-orphan")
    payout_transactions = relationship("PayoutTransaction", back_populates="user", cascade="all, delete-orphan")
    payin_transactions = relationship("PayinTransaction", back_populates="user", cascade="all, delete-orphan")
    charges = relationship("Charge", back_populates="user", cascade="all, delete-orphan")
    webhook_url = relationship("WebhookURL", back_populates="user", uselist=False, cascade="all, delete-orphan")
    webhook_logs = relationship("WebhookLog", back_populates="user", cascade="all, delete-orphan")

