"""
User Service model (many-to-many relationship)
"""

from sqlalchemy import Column, ForeignKey, Text, UniqueConstraint
from sqlalchemy.orm import relationship
from sqlalchemy.dialects.postgresql import UUID
from app.common.base_model import BaseModel
from app.common.mixins import StatusMixin


class UserService(BaseModel, StatusMixin):
    """User Service model (linking users to services)"""
    
    __tablename__ = "user_services"
    
    user_id = Column(UUID(as_uuid=True), ForeignKey("users.id"), nullable=False, index=True)
    service_id = Column(UUID(as_uuid=True), ForeignKey("services.id"), nullable=False, index=True)
    notes = Column(Text, nullable=True)
    
    # Relationships
    user = relationship("User", back_populates="user_services")
    service = relationship("Service", back_populates="user_services")
    
    # Unique constraint on user_id + service_id
    __table_args__ = (
        UniqueConstraint("user_id", "service_id", name="uq_user_service"),
    )

