"""
Wallet model
"""

from sqlalchemy import Column, String, Numeric, Boolean, ForeignKey
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from app.common.base_model import BaseModel


class Wallet(BaseModel):
    """Wallet model for user balances"""
    
    __tablename__ = "wallets"
    
    user_id = Column(UUID(as_uuid=True), ForeignKey("users.id"), nullable=False, index=True, unique=True)
    main = Column(Numeric(15, 2), nullable=False, default=0.00)  # Main wallet balance
    reserve = Column(Numeric(15, 2), nullable=False, default=0.00)  # Reserve/hold balance
    status = Column(String(50), nullable=False, default="active", index=True)  # active, inactive, suspended
    
    # Relationships
    user = relationship("User", back_populates="wallet")
    transactions = relationship("WalletTransaction", back_populates="wallet", cascade="all, delete-orphan")

