"""
Wallet Transaction model
"""

from sqlalchemy import Column, String, Numeric, ForeignKey, Boolean
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from app.common.base_model import BaseModel


class WalletTransaction(BaseModel):
    """Wallet Transaction model for transaction logs"""
    
    __tablename__ = "wallet_transactions"
    
    user_id = Column(UUID(as_uuid=True), ForeignKey("users.id"), nullable=False, index=True)
    wallet_id = Column(UUID(as_uuid=True), ForeignKey("wallets.id"), nullable=False, index=True)
    txn_type = Column(String(100), nullable=False, index=True)  # Reason code for transaction
    type = Column(String(20), nullable=False, index=True)  # debit or credit
    amount = Column(Numeric(15, 2), nullable=False)
    opening = Column(Numeric(15, 2), nullable=False)  # Opening balance
    closing = Column(Numeric(15, 2), nullable=False)  # Closing balance
    txnid = Column(String(100), nullable=False, index=True)  # Transaction ID (not unique to allow refunds)
    refunded = Column(Boolean, default=False, nullable=False, index=True)  # True if this transaction has been refunded
    is_refund = Column(Boolean, default=False, nullable=False, index=True)  # True if this transaction entry is a refund
    
    # Relationships
    user = relationship("User", back_populates="wallet_transactions")
    wallet = relationship("Wallet", back_populates="transactions")

