"""
Webhook Log model
"""

from sqlalchemy import Column, String, ForeignKey, Integer, JSON
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from app.core.database import Base
from app.common.mixins import TimestampMixin


class WebhookLog(Base, TimestampMixin):
    """Webhook Log model - logs every webhook that is sent"""
    
    __tablename__ = "webhook_logs"
    
    id = Column(Integer, primary_key=True, index=True, autoincrement=True)
    user_id = Column(UUID(as_uuid=True), ForeignKey("users.id"), nullable=False, index=True)
    service_id = Column(UUID(as_uuid=True), ForeignKey("services.id"), nullable=False, index=True)
    txnid = Column(String(100), nullable=False, index=True)
    payload = Column(JSON, nullable=False)
    response = Column(JSON, nullable=True)
    # created_at is inherited from TimestampMixin
    
    # Relationships
    user = relationship("User", back_populates="webhook_logs")
    service = relationship("Service", back_populates="webhook_logs")

