"""
Webhook URL model
"""

from sqlalchemy import Column, String, ForeignKey, Integer, UniqueConstraint
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from app.core.database import Base
from app.common.mixins import TimestampMixin


class WebhookURL(Base, TimestampMixin):
    """Webhook URL model - one webhook URL per user"""
    
    __tablename__ = "webhook_urls"
    
    id = Column(Integer, primary_key=True, index=True, autoincrement=True)
    user_id = Column(UUID(as_uuid=True), ForeignKey("users.id"), nullable=False, unique=True, index=True)
    url = Column(String(500), nullable=False)
    
    # Relationships
    user = relationship("User", back_populates="webhook_url")

