"""
Admin repository
"""

from typing import Optional
from sqlalchemy.orm import Session
from app.common.base_repository import BaseRepository
from app.models.admin import Admin


class AdminRepository(BaseRepository[Admin]):
    """Admin repository"""

    def __init__(self, db: Session):
        super().__init__(Admin, db)

    def get_by_email(self, email: str) -> Optional[Admin]:
        """Get admin by email"""
        return self.db.query(self.model).filter(
            self.model.email == email
        ).first()

