"""
API Key repository
"""

from typing import Optional
from sqlalchemy.orm import Session
from app.common.base_repository import BaseRepository
from app.models.api_key import APIKey


class APIKeyRepository(BaseRepository[APIKey]):
    """API Key repository"""

    def __init__(self, db: Session):
        super().__init__(APIKey, db)

    def get_by_user_id(self, user_id: str) -> Optional[APIKey]:
        """Get API key by user ID"""
        return self.db.query(self.model).filter(
            self.model.user_id == user_id
        ).first()

    def get_by_api_key(self, api_key: str) -> Optional[APIKey]:
        """Get API key by API key string"""
        return self.db.query(self.model).filter(
            self.model.api_key == api_key
        ).first()

