"""
KYC repository
"""

from typing import Optional
from sqlalchemy.orm import Session
from sqlalchemy.dialects.postgresql import UUID
from app.common.base_repository import BaseRepository
from app.models.kyc import KYC


class KYCRepository(BaseRepository[KYC]):
    """KYC repository"""

    def __init__(self, db: Session):
        super().__init__(KYC, db)

    def get_latest_by_user_id(self, user_id: UUID) -> Optional[KYC]:
        """Get the latest KYC record for a user (ordered by created_at desc)"""
        return self.db.query(self.model).filter(
            self.model.user_id == user_id
        ).order_by(self.model.created_at.desc()).first()

