"""
Payin Transaction repository
"""

from typing import Optional, List
from sqlalchemy.orm import Session
from app.common.base_repository import BaseRepository
from app.models.payin_transaction import PayinTransaction


class PayinTransactionRepository(BaseRepository[PayinTransaction]):
    """Payin Transaction repository"""

    def __init__(self, db: Session):
        super().__init__(PayinTransaction, db)

    def get_by_user_id(self, user_id: str, skip: int = 0, limit: int = 100) -> List[PayinTransaction]:
        """Get all payin transactions for a user"""
        return self.db.query(self.model).filter(
            self.model.user_id == user_id
        ).order_by(self.model.created_at.desc()).offset(skip).limit(limit).all()

    def get_by_txnid(self, txnid: str) -> Optional[PayinTransaction]:
        """Get payin transaction by transaction ID"""
        return self.db.query(self.model).filter(
            self.model.txnid == txnid
        ).first()
    
    def get_by_provider_reference_id(self, provider_reference_id: str) -> Optional[PayinTransaction]:
        """Get payin transaction by provider reference ID"""
        return self.db.query(self.model).filter(
            self.model.provider_reference_id == provider_reference_id
        ).first()
    
    def get_by_user_reference_id(self, user_reference_id: str) -> Optional[PayinTransaction]:
        """Get payin transaction by user reference ID"""
        return self.db.query(self.model).filter(
            self.model.user_reference_id == user_reference_id
        ).first()

