"""
Service repository
"""

from typing import Optional
from sqlalchemy.orm import Session
from app.common.base_repository import BaseRepository
from app.models.service import Service


class ServiceRepository(BaseRepository[Service]):
    """Service repository"""

    def __init__(self, db: Session):
        super().__init__(Service, db)

    def get_by_code(self, code: str) -> Optional[Service]:
        """Get service by code"""
        return self.db.query(self.model).filter(
            self.model.code == code
        ).first()

