"""
User repository
"""

from typing import Optional
from sqlalchemy.orm import Session
from app.common.base_repository import BaseRepository
from app.models.user import User


class UserRepository(BaseRepository[User]):
    """User repository"""

    def __init__(self, db: Session):
        super().__init__(User, db)

    def get_by_email(self, email: str) -> Optional[User]:
        """Get user by email"""
        return self.db.query(self.model).filter(
            self.model.email == email,
            self.model.deleted_at.is_(None)
        ).first()

