"""
User Service repository
"""

from typing import Optional, List
from sqlalchemy.orm import Session
from sqlalchemy.dialects.postgresql import UUID
from app.common.base_repository import BaseRepository
from app.models.user_service import UserService


class UserServiceRepository(BaseRepository[UserService]):
    """User Service repository"""

    def __init__(self, db: Session):
        super().__init__(UserService, db)

    def get_by_user_and_service(self, user_id: str, service_id: str) -> Optional[UserService]:
        """Get user service by user_id and service_id"""
        return self.db.query(self.model).filter(
            self.model.user_id == user_id,
            self.model.service_id == service_id
        ).first()

    def get_by_user_id(self, user_id: str) -> List[UserService]:
        """Get all services for a user"""
        return self.db.query(self.model).filter(
            self.model.user_id == user_id
        ).all()

