"""
Wallet repository
"""

from typing import Optional
from sqlalchemy.orm import Session
from app.common.base_repository import BaseRepository
from app.models.wallet import Wallet


class WalletRepository(BaseRepository[Wallet]):
    """Wallet repository"""

    def __init__(self, db: Session):
        super().__init__(Wallet, db)

    def get_by_user_id(self, user_id: str, for_update: bool = False) -> Optional[Wallet]:
        """
        Get wallet by user ID
        
        Args:
            user_id: User ID
            for_update: If True, lock the row for update (SELECT FOR UPDATE)
                       This prevents race conditions in concurrent transactions
        
        Returns:
            Wallet instance or None
        """
        query = self.db.query(self.model).filter(
            self.model.user_id == user_id
        )
        if for_update:
            query = query.with_for_update()
        return query.first()

