"""
Webhook URL repository
"""

from typing import Optional
from sqlalchemy.orm import Session
from app.common.base_repository import BaseRepository
from app.models.webhook_url import WebhookURL


class WebhookURLRepository(BaseRepository[WebhookURL]):
    """Webhook URL repository"""

    def __init__(self, db: Session):
        super().__init__(WebhookURL, db)

    def get_by_user_id(self, user_id: str) -> Optional[WebhookURL]:
        """Get webhook URL by user ID"""
        return self.db.query(self.model).filter(
            self.model.user_id == user_id
        ).first()

