"""
Admin schemas
"""

from typing import Optional
from pydantic import BaseModel, EmailStr, Field, ConfigDict
from uuid import UUID
from datetime import datetime


class AdminCreate(BaseModel):
    """Admin creation schema"""
    email: EmailStr
    password: str = Field(..., min_length=8)
    full_name: str = Field(..., min_length=1)


class AdminUpdate(BaseModel):
    """Admin update schema"""
    email: Optional[EmailStr] = None
    full_name: Optional[str] = None
    is_active: Optional[bool] = None


class AdminLogin(BaseModel):
    """Admin login schema"""
    email: EmailStr
    password: str


class AdminResponse(BaseModel):
    """Admin response schema"""
    id: UUID
    email: str
    full_name: str
    is_active: bool
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)

