"""
API Key schemas
"""

from typing import Optional, List
from pydantic import BaseModel, Field, ConfigDict
from uuid import UUID
from datetime import datetime


class APIKeyGenerateResponse(BaseModel):
    """API Key generation response with secret (only shown once)"""
    id: UUID
    user_id: UUID
    api_key: str
    api_secret: str  # Only visible once during generation
    active: bool
    ips: Optional[List[str]] = None
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)


class APIKeyResponse(BaseModel):
    """API Key response (without secret)"""
    id: UUID
    user_id: UUID
    api_key: str
    active: bool
    ips: Optional[List[str]] = None
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)


class APIKeyUpdate(BaseModel):
    """API Key update schema"""
    active: Optional[bool] = None
    ips: Optional[List[str]] = Field(None, description="List of whitelisted IP addresses")


class APIKeyAddIPRequest(BaseModel):
    """Request schema for adding IP to whitelist"""
    ip: str = Field(..., description="IP address to add to whitelist")


class APIKeyIPsResponse(BaseModel):
    """Response schema for whitelisted IPs"""
    ips: List[str] = Field(default_factory=list, description="List of whitelisted IP addresses")

