"""
KYC Document schemas
"""

from typing import Optional
from pydantic import BaseModel, Field, ConfigDict
from uuid import UUID
from datetime import datetime


class KYCDocCreate(BaseModel):
    """KYC Document creation schema (for internal use)"""
    kyc_id: UUID
    document_type: str = Field(..., min_length=1)
    document_number: str = Field(..., min_length=1)
    front_file_path: str = Field(..., min_length=1)
    front_file_name: str = Field(..., min_length=1)
    back_file_path: Optional[str] = None
    back_file_name: Optional[str] = None
    file_size: Optional[str] = None
    mime_type: Optional[str] = None
    description: Optional[str] = None


class KYCDocUpdate(BaseModel):
    """KYC Document update schema"""
    kyc_id: Optional[UUID] = None
    document_type: Optional[str] = None
    document_number: Optional[str] = None
    front_file_path: Optional[str] = None
    front_file_name: Optional[str] = None
    back_file_path: Optional[str] = None
    back_file_name: Optional[str] = None
    file_size: Optional[str] = None
    mime_type: Optional[str] = None
    description: Optional[str] = None
    status: Optional[str] = None


class KYCDocResponse(BaseModel):
    """KYC Document response schema"""
    id: UUID
    user_id: UUID
    kyc_id: UUID
    document_type: str
    document_number: str
    front_file_path: str
    front_file_name: str
    back_file_path: Optional[str]
    back_file_name: Optional[str]
    file_size: Optional[str]
    mime_type: Optional[str]
    description: Optional[str]
    status: str
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)

