"""
Service schemas
"""

from typing import Optional
from pydantic import BaseModel, Field, ConfigDict
from decimal import Decimal
from uuid import UUID
from datetime import datetime


class ServiceCreate(BaseModel):
    """Service creation schema"""
    name: str = Field(..., min_length=1)
    description: Optional[str] = None
    code: str = Field(..., min_length=1)
    price: Decimal = Field(..., ge=0)
    currency: str = Field(default="USD", min_length=3, max_length=10)


class ServiceUpdate(BaseModel):
    """Service update schema"""
    name: Optional[str] = None
    description: Optional[str] = None
    code: Optional[str] = None
    price: Optional[Decimal] = None
    currency: Optional[str] = None
    status: Optional[str] = None


class ServiceResponse(BaseModel):
    """Service response schema"""
    id: UUID
    name: str
    description: Optional[str]
    code: str
    price: Decimal
    currency: str
    status: str
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)

