"""
User schemas
"""

from typing import Optional
from pydantic import BaseModel, EmailStr, Field, ConfigDict
from uuid import UUID
from datetime import datetime


class UserCreate(BaseModel):
    """User creation schema"""
    email: EmailStr
    password: str = Field(..., min_length=8)
    full_name: str = Field(..., min_length=1)
    phone: Optional[str] = None


class UserUpdate(BaseModel):
    """User update schema"""
    email: Optional[EmailStr] = None
    full_name: Optional[str] = None
    phone: Optional[str] = None
    is_active: Optional[bool] = None


class UserLogin(BaseModel):
    """User login schema"""
    email: EmailStr
    password: str


class UserResponse(BaseModel):
    """User response schema"""
    id: UUID
    email: str
    full_name: str
    phone: Optional[str]
    is_active: bool
    kyc_id: Optional[UUID] = None  # Latest KYC ID
    kyc_status: Optional[str] = None  # Latest KYC status
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)

