"""
User Service schemas
"""

from typing import Optional
from pydantic import BaseModel, Field, ConfigDict
from uuid import UUID
from datetime import datetime


class UserServiceCreate(BaseModel):
    """User Service creation schema"""
    service_id: UUID
    notes: Optional[str] = None


class UserServiceUpdate(BaseModel):
    """User Service update schema"""
    notes: Optional[str] = None
    status: Optional[str] = None


class UserServiceResponse(BaseModel):
    """User Service response schema"""
    id: UUID
    user_id: UUID
    service_id: UUID
    status: str
    notes: Optional[str]
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)


class UserServiceWithDetailsResponse(BaseModel):
    """User Service response with service details"""
    service_id: UUID
    service_name: str
    service_code: str
    service_description: Optional[str]
    service_price: str
    service_currency: str
    service_status: str
    user_service_id: Optional[UUID] = None
    user_service_status: Optional[str] = None
    user_service_notes: Optional[str] = None
    is_active: bool = False
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None

    model_config = ConfigDict(from_attributes=True)


class UserServiceWithServiceInfoResponse(BaseModel):
    """User Service response with service name, code, and status"""
    id: UUID
    user_id: UUID
    service_id: UUID
    service_name: str
    service_code: str
    service_status: str
    status: str
    notes: Optional[str]
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)

