"""
Wallet schemas
"""

from typing import Optional
from pydantic import BaseModel, Field, ConfigDict
from uuid import UUID
from datetime import datetime
from decimal import Decimal


class WalletResponse(BaseModel):
    """Wallet response schema"""
    id: UUID
    user_id: UUID
    main: Decimal
    reserve: Decimal
    status: str
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)


class WalletUpdate(BaseModel):
    """Wallet update schema"""
    status: Optional[str] = None


class WalletCreate(BaseModel):
    """Wallet creation schema (usually auto-created)"""
    user_id: UUID


class WalletGetRequest(BaseModel):
    """Request schema for getting wallet"""
    user_id: UUID = Field(..., description="User ID")

