"""
Webhook Log schemas
"""

from typing import Optional, Dict, Any
from pydantic import BaseModel, Field, ConfigDict
from uuid import UUID
from datetime import datetime


class WebhookLogResponse(BaseModel):
    """Webhook Log response schema"""
    id: int
    service_id: UUID
    txnid: str
    payload: Dict[str, Any]
    response: Optional[Dict[str, Any]] = None
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)


class WebhookLogWithServiceResponse(BaseModel):
    """Webhook Log response with service information (for admin)"""
    id: int
    user_id: UUID
    service_id: UUID
    service_name: Optional[str] = None
    service_code: Optional[str] = None
    txnid: str
    payload: Dict[str, Any]
    response: Optional[Dict[str, Any]] = None
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)


class WebhookLogUserResponse(BaseModel):
    """Webhook Log response for users (with service_code instead of service_id)"""
    id: int
    service_code: str
    txnid: str
    payload: Dict[str, Any]
    response: Optional[Dict[str, Any]] = None
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)

